//___________________________________
//                                   \
// Esthetica Visual Effects. version 1.0	$Id: esthetica.js 61 2007-09-09 06:46:48Z nilton $
//___________________________________/
/*
	Put Esthetica.UpdateAndDraw(); inside your Render script. 
	

	Esthetica.addSfx(MainChar,'domearound');

*/
var Esthetica= {

	UpdateAndDraw:function(){}, 

	done:function(){this.UpdateAndDraw=function(){};},

	darkroom: function(sprite){
		Spotlight.init();
		Spotlight.Around(sprite||GetInputPerson());
		Esthetica.UpdateAndDraw=function(){Spotlight.UpdateAndDraw();};
	},

	SFXSprites:new Object(),

	addSfx: function(sprite,sfx) {
        	//this.SFXSprites[sfx][this.SFXSprites[sfx].length]=sprite;
		var i = this.SFXSprites[sfx].length-1;
		if(i>-1){
			do{ if(sprite == this.SFXSprites[sfx][i]) return -1; }while(i--);
		}
		this.SFXSprites[sfx].push(sprite);
		this.doSFXs=this.doSFXs_;
		this.UpdateAndDraw=function(){this.doSFXs();};
		return 0;
	},

        doSFXs_: function() { 
		var showed=0;
		for (var sfx in this.SFXSprites){
			var i=this.SFXSprites[sfx].length-1; 
			if(i==-1) continue;
			do{
                		sprite=this.SFXSprites[sfx][i];
                		this[sfx].show(sprite);
				++showed;
                	}while(i--);
		};
		if(showed==0){this.doSFXs=function(){};this.UpdateAndDraw= Spotlight.active? function(){Spotlight.UpdateAndDraw();}:function(){};}
        },

	doSFXs:function(){},

	rmSfx: function(sprite,sfx) {
        	var i=this.SFXSprites[sfx].length-1;
        	if(i<0) return;
        	do{ 
			if(this.SFXSprites[sfx][i]==sprite) {
				this.SFXSprites[sfx][i]=this.SFXSprites[sfx][this.SFXSprites[sfx].length-1];--this.SFXSprites[sfx].length
			} 
		} while(i--);
        	GarbageCollect();
	},

	registerSFX: function(sfx,show,add,rm){
		this.SFXSprites[sfx]=new Array();
		this[sfx]={show:function(){},add:function(sprite){Esthetica.addSfx(sprite,sfx)},rm:function(sprite){Esthetica.rmSfx(sprite,sfx)}};
		if(show) this[sfx].show=show;
		if(add) this[sfx].add=add;
		if(rm) this[sfx].rm=rm;
	},

	unregisterSFX:function(sfx){
		delete this[sfx];
		delete this.SFXSprites[sfx];
		GarbageCollect();
	}
};


//Call like: Esthetica['hiccup'].add(sprite);
Esthetica.registerSFX('hiccup', 
	function(sprite){ hiccup(sprite);this['hiccup'].rm(sprite)},
	undefined, //use the defaults
	function(sprite){this.rmSfx(sprite,'hiccup');}
);

Esthetica.registerSFX('domearound',
	function(sprite){Dome.Around(sprite);}
);

Esthetica.registerSFX('poing'); 
Esthetica.poing.show=function(sprite){ LL.write(sprite+" does POING!") } 
//Esthetica.poing.add=function(sprite,direction){ Esthetica.addSfx(sprite,'poing');Abort("Add to poing"+sprite) } 
Esthetica.poing.rm=function(sprite){ Esthetica.rmSfx(sprite,'poing');Abort("rm from poing"+sprite) } 

//Esthetica['encolorize'].add(sprite,r,g,b,a);
Esthetica.registerSFX('encolorize',
	//show
	function(sprite){
		var c = Esthetica['encolorize'].vars['sprite']['pos']--;
		if(c==0){
			SetPersonMask(sprite,CreateColor(
				Esthetica['encolorize'].vars['sprite']['WasPersonMask'].red,
				Esthetica['encolorize'].vars['sprite']['WasPersonMask'].green,
				Esthetica['encolorize'].vars['sprite']['WasPersonMask'].blue,
				Esthetica['encolorize'].vars['sprite']['WasPersonMask'].alpha));
			Esthetica['encolorize'].rm(sprite,'encolorize');
			delete( Esthetica['encolorize'].vars['sprite'] );
			return;
		}
		if(c>32){
			var i = (64-c)/32; 
			SetPersonMask(sprite,CreateColor(
			(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['r'])*i)),
			(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['g'])*i)),
			(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['b'])*i)),
			Esthetica['encolorize'].vars['sprite']['a']));
		}else{
			var i = c/32;
			SetPersonMask(sprite,CreateColor(
		 	(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['r'])*i)),
		 	(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['g'])*i)),
		 	(255-Math.floor((255-Esthetica['encolorize'].vars['sprite']['b'])*i)),
			Esthetica['encolorize'].vars['sprite']['a']));
		} 
	},
	//add
	function(sprite,r,g,b,a){
		if(Esthetica['encolorize'].vars['sprite']) return; //no retrigger
		Esthetica['encolorize'].vars['sprite']= {pos:65, WasPersonMask:GetPersonMask(sprite), r:r, g:g, b:b, a:a};
	Esthetica.addSfx(sprite,'encolorize');
	}
	//rm

);
Esthetica['encolorize'].vars=new Object();




//----- SPECIAL FX -----//

function hiccup(sprite)	//v1.4 Idea from "GBA(Golden Sun)" coded to Sphere by FutureBoy nil
{
	var isNPC=true;
	if(!sprite)sprite=Lithonite.GIP;
	if(sprite==Lithonite.GIP) isNPC=false;
	if(!isNPC){
		if(GetPersonValue(sprite,'moving')==2)return;//&&is input attached, no endless hiccups
		SetPersonValue(sprite,'moving',2);
		if(IsInputAttached()){
			SetDelayScript(17, "AttachInput('"+sprite+"');");
			DetachInput();
		}
		SetDelayScript(20, "SetPersonValue('"+sprite+"','moving',0);");
	}else{
		if(GetPersonValue(sprite,'moving')==2){SetDelayScript(8, "hiccup('"+sprite+"');");return;}//Do not mix multiple hiccups (No retrigger while active)
		SetPersonValue(sprite,'moving',2);
		QueuePersonCommand(sprite, COMMAND_WAIT, true);
		var i=18;do{QueuePersonCommand(sprite, COMMAND_WAIT, false)}while(--i);
		SetDelayScript(20, "SetPersonValue('"+sprite+"','moving',0);");
	}

	//prepare to detach camera to prevent the screen from quaking
	if (IsCameraAttached()&&(GetCameraPerson()==sprite))
	{
		SetDelayScript(16, "AttachCamera('"+GetCameraPerson()+"');");
		DetachCamera();
	}

 	var XX=GetPersonX(sprite)+GetPersonSpriteset(sprite).images[0].width*(0.1);
	var YY=GetPersonY(sprite)-GetPersonSpriteset(sprite).images[0].height*(0.07)-1;
	SetDelayScript(8,  "SetPersonScaleFactor('"+sprite+"', 0.8,1.15);");
	SetDelayScript(8,  "SetPersonXYFloat('"+sprite+"',"+XX+","+YY+");");

	var XX=GetPersonX(sprite);
	var YY=GetPersonY(sprite);
	SetDelayScript(16, "SetPersonScaleFactor('"+sprite+"', 1,1);");
	SetDelayScript(16, "SetPersonXYFloat('"+sprite+"',"+XX+","+YY+");");

	if(isNPC){ //Because its BASE shrinks, another NPC can block this sprite. (in newer Sphere versions, the base just offsets)
		IgnorePersonObstructions(sprite, true);
		Lithonite.whenPersonNotObstructed(19,sprite,"IgnorePersonObstructions('"+sprite+"',false);",1,16); //Deignoreobstructions as soon as possible.
	}

}

function Jump(sprite,direction,stampede,hop)
{
	var isNPC=true;
	if(!sprite)sprite=GetCurrentPerson();
	if(sprite==Lithonite.GIP) isNPC=false;

	if(!isNPC){
		if(GetPersonValue(sprite,'moving')==2)return;//&&is input attached, no endless hiccups
		if(IsInputAttached()){
			SetDelayScript(12, "AttachInput('"+sprite+"');");
			DetachInput();
		}
		SetDelayScript(12, "SetPersonValue('"+sprite+"','moving',0);");
	}else{
		if(GetPersonValue(sprite,'moving')==2){
			SetDelayScript(6, "Jump('"+sprite+"','"+direction+"');");return;
		}; //Do not mix multiple jumps (No retrigger while active)
		QueuePersonCommand(sprite, COMMAND_WAIT, true);
		var i=12;do{QueuePersonCommand(sprite, COMMAND_WAIT, false)}while(--i);
		SetDelayScript(12, "SetPersonValue('"+sprite+"','moving',0);");
	}

	SetPersonValue(sprite,'moving',2);

	var WasInputAttached = IsInputAttached();
	var WasCameraAttached = IsCameraAttached() && ( GetCameraPerson()==sprite );

	if (WasInputAttached && !isNPC) DetachInput();
	if (WasCameraAttached) DetachCamera();

	WasCameraX = GetCameraX();
	WasCameraY = GetCameraY();

		SetDelayScript(1,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')-3);");
		SetDelayScript(2,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')-2);");
		SetDelayScript(3,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')-1);");
		SetDelayScript(4,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')+1);");
		SetDelayScript(5,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')+2);");
		SetDelayScript(6,  "SetPersonY('"+sprite+"', GetPersonY('"+sprite+"')+3);");
		SetDelayScript(7,  "SetPersonValue('"+sprite+"','moving',0);");
		if (stampede){
			camera=GetCameraY()-1;
			for(var i=5;i<10;i++){SetDelayScript(i,"SetCameraY("+camera+");");}
		}
		if(!isNPC){
			if (WasCameraAttached)
				SetDelayScript(10, "AttachCamera('"+sprite+"');"); 
			if (WasInputAttached) 
				SetDelayScript(10, "AttachInput('"+sprite+"');"); 
		}
	if(direction){
		var xx=0;var yy=0;
		hop=hop||1;
		switch(direction){
			case 'n': yy=-hop;break;
			case 's': yy=hop; break;
			case 'w': xx=-hop;break;
			case 'e': xx=hop; break;
		}
		for(var i=1;i<5;i++){SetDelayScript(i,
			"SetPersonXYFloat('"+sprite+"',"+xx+"+GetPersonX('"+sprite+"'),"+yy+"+GetPersonY('"+sprite+"'))");}
	}
}


//Encolorize(undefined,0,255,255,228); //temporal Greenish hue on spriteset
function Encolorize(sprite,r,g,b,a)
{
	if (!sprite && IsInputAttached() ) sprite=GetInputPerson();

	if ( sprite )
	{
		if(GetPersonValue(sprite,'moving')==2)return;//no retrigger
		SetPersonValue(sprite,'moving',2);
		var WasPersonMask = GetPersonMask(sprite)
		for (var i=1;i< 32;i++)
		SetDelayScript(i,"SetPersonMask('"+sprite+"',CreateColor("+(255-Math.floor((255-r)*i/32))+","+(255-Math.floor((255-g)*i/32))+","+(255-Math.floor((255-b)*i/32))+","+a+"));");
		for (var i=1;i< 32;i++)
		SetDelayScript(31+i,"SetPersonMask('"+sprite+"',CreateColor("+(255-Math.floor((255-r)*(32-i)/32))+","+(255-Math.floor((255-g)*(32-i)/32))+","+(255-Math.floor((255-b)*(32-i)/32))+","+a+"));");
		
		SetDelayScript(64,  "SetPersonMask('"+sprite+"',CreateColor("+WasPersonMask.red+","+WasPersonMask.green+","+WasPersonMask.blue+","+WasPersonMask.alpha+"));");
		SetDelayScript(65,  "SetPersonValue('"+sprite+"','moving',0);");
	}
	else { /* Error: No "who" given and couldnt get default*/ }
}

function QuakeAt(RndX,RndY){
 SetCameraX(GetCameraX()+RndX);
 SetCameraY(GetCameraY()+RndY);
 RenderMap();
 FlipScreen();
}

var mov_ScreenImage ;
function StretchIt(qty) {
	mov_ScreenImage = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
	ApplyColorMask(CreateColor(0,0,0,255));
	mov_ScreenImage.transformBlit(	0, 			0, 
					GetScreenWidth(),	0, 
					GetScreenWidth()+qty, 	GetScreenHeight(),
					-qty, 			GetScreenHeight()
	);
}

function SeaSick(angle) {
	mov_ScreenImage = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
	mov_ScreenImage.rotateBlit(GetScreenWidth() % 2, GetScreenWidth() % 2, angle);
}

function Quake(times, scale){
	if (this.quaking!=2){ //No retrigger while active
		var WasCameraAttached = IsCameraAttached();
		this.quaking=2;
		if (WasCameraAttached) 
			sprite=GetCameraPerson();

		if ( sprite ) {
			//if (WasCameraAttached) DetachCamera();
			//WasCameraX = GetCameraX();
			//WasCameraY = GetCameraY();
			for (var i=1;i< times;i++) { 
				RndX=Math.floor(Math.random() *  scale);
				RndY=Math.floor(Math.random() *  scale);

				for (var j=0;j<7;j++) {
					SetDelayScript(8*i+j,"QuakeAt("+RndX+","+RndY+"); ");
				}
			}
			//if (WasCameraAttached) 
				//	{ SetDelayScript(8*times+1, "AttachCamera('"+sprite+"');"); }
				SetDelayScript(8*times, "Quake.quaking=0;");
		} else { /* Error: No "who" given and couldnt get default*/ }
	}
}
Quake.quaking=0;




function EnergyBlast(radius,color) //REDEFINE
{

while(!IsKeyPressed(KEY_X))
{ 
RenderMap();
//First, make the mask

var a=16+Math.floor(Math.sin(GetTime()/100)*2);
var b=10;
var c=48;
var x_old=-1;

for(var theta_deg=0;theta_deg<180;theta_deg++)
{
 var x= Math.round(a*Math.cos(theta_deg*Math.PI/180));	//theta_rad= Math.round(theta_deg*Math.PI/180);
 if (x!=x_old)
 {
 
  y1= Math.round(b*Math.sin(theta_deg*Math.PI/180));
  y2= Math.round(c*Math.sin(theta_deg*Math.PI/180*-1));

  for (var y=y2;y<y1;y++)
  {
   Point(x+160-MapToScreenX(0,GetPersonX(GetInputPerson()))+GetPersonX(GetInputPerson()), 
	 y+120-MapToScreenY(0,GetPersonY(GetInputPerson()))+GetPersonY(GetInputPerson()) + 10, 
	CreateColor(55, 55, 
			Math.floor(Math.sin(GetTime()/100)*127)+127,
			55));
  }
  x_old=x;
 }
}


//Mix them, Cut them, clean area redraw and flipscreen
FlipScreen();
}

}

var Dome = {
 S:0,
 R:0,
 GPX:0,
 GPY:0,

 col: function(R) {return CreateColor(55,55,this.R*127+127,55)},

 Around: function(sprite) {
  this.R=Math.sin(GetTime()/100);
  this.GPX=MapToScreenX(0,GetPersonX(sprite));
  this.GPY=MapToScreenY(0,GetPersonY(sprite))+10;
  for(var j=4;j<16;j+=4)
   this.At(this.GPX,this.GPY,this.col(this.R),j+this.R*2,j-6,j+32);
 },

 At: function(x_c,y_c,color,a,b,c) {
  var i=Math.floor(a);
  do{
   this.S=Math.sin(Math.acos(i/a));
   y1=y_c+b*this.S;
   y2=y_c-c*this.S;
   Line(x_c+i,y2,x_c+i,y1,color);
   Line(x_c-i,y2,x_c-i,y1,color); 
  }while(--i);
  Line(x_c,y_c-c,x_c,y_c+b,color);
 }

}

// Example on how to make another dome:
//Dome2=CloneObj(Dome);
//Dome2.col=function(){return CreateColor(128,10,10,32);} //set a fixed color


// -----------------------------


//-----------------------------------------------------------------//


function Mode7()
{
	var zig=Math.floor(Math.sin(GetTime()/512)*20);
	//var angle=Math.sin((GetTime()));
	if (Mode7.count!=0) {
		++Mode7.count;
		if (Mode7.count==4) Mode7.count=0;
		//Mode7.ScreenImage.transformBlit(Math.sin(GetTime()/100)*5,0, Mode7.GSW,0, Mode7.GSW+30,Mode7.GSH, 0-30,Mode7.GSH);
		Mode7.ScreenImage.transformBlit(zig,0, Mode7.GSW+zig,0, Mode7.GSW+30-zig,Mode7.GSH, 0-30-zig,Mode7.GSH);
		return;
	}
	Mode7.count++;
	var surf=GrabSurface(0, 0, Mode7.GSW, Mode7.GSH);
// mov_ScreenImage = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
// var surf=mov_ScreenImage.createSurface();
//surf.rescale(Mode7.GSW>>1,Mode7.GSH>>1);
	Mode7.ScreenImage=surf.createImage();
//Mode7.ScreenImage.transformBlit(0,0, Mode7.GSW,0, Mode7.GSW+30,Mode7.GSH, 0-30,Mode7.GSH);
 
	Mode7.ScreenImage.transformBlit(zig,0, Mode7.GSW+zig,0, Mode7.GSW+30-zig,Mode7.GSH, 0-30-zig,Mode7.GSH);
}
Mode7.GSW=GetScreenWidth();
Mode7.GSH=GetScreenHeight();
Mode7.count=0;

//--------------- ChangeSpriteSet script./ COLORIZE.js

function GrayAllTiles() { colorMatrixMap(ColorMatrix.grayscale); }


function colorMatrixMap(cm,skiparray) {
	if (skiparray == undefined) skiparray = new Array();
	if (IsMapEngineRunning()) { 
		var i=GetNumTiles()-1;
		do {
			if (skiparray.length>i && skiparray[i]) continue;
			var stile = GetTileImage(i).createSurface();
			stile.applyColorFX(0, 0, stile.width, stile.height,  cm);
			SetTileImage(i, stile.createImage() );
		} while (i--);
	}
}

function GrayAllSprites() {
	var Persons=GetPersonList();
	var i=Persons.length-1;
	do {
		ColorMatrixPerson(Persons[i],ColorMatrix.grayscale);
	} while (i--);
}

/**
 * Applies a ColorMatrix to a Person
 * @param {string} person Name of the person you want to apply the colormatrix to
 * @param {colormatrix} colormatrix A colormatrix, See the variable ColorMatrix for predefined values.
 */
function ColorMatrixPerson(person,colormatrix) {
	var GPSS = GetPersonSpriteset(person);
	var surf1;
	var i = GPSS.images.length-1;
	do {
		surf1= GPSS.images[i].createSurface();
		surf1.applyColorFX(0, 0, surf1.width, surf1.height,  colormatrix);
		GPSS.images[i]=surf1.createImage();
	} while(i--);
	SetPersonSpriteset(person,GPSS);
}

/**
 * Applies a ColorMatrix to a Person Direction
 * @param {string} person Name of the person you want to apply the colormatrix to
 * @param {colormatrix} colormatrix A colormatrix, See the variable ColorMatrix for predefined values.
 * @param {string} direction Direction you want the ColorMatrix to be applied to.
 */
function ColorMatrixPersonDirection(person,colormatrix,direction) {
	var GPSS= GetPersonSpriteset(person);
	var i=GPSS.directions.length-1;
	do {
		if(GPSS.directions[i].name==direction){
			var surf1; var f;
			var j=GPSS.directions[i].frames.length-1;
			do{
				f=GPSS.directions[i].frames[j].index
				surf1= GPSS.images[f].createSurface();
				surf1.applyColorFX(0, 0, surf1.width, surf1.height,  colormatrix);
				GPSS.images[f]=surf1.createImage();
			}while(j--);
		  	SetPersonSpriteset(person,GPSS);
			return;
		}
	}while(i--);
}

/**
 * Applies a ColorMatrix to the tiles of a map
 * @param {colormatrix} cm A colormatrix, See the variable ColorMatrix for predefined values.
 * @param {array} skiparray Where the index of a tile is true to skip it. Optional.
 * example: 
 * 	var sA=new Array();
 *	sA[6]=1; //Will make tile with index 6 stay like it is.
 * 	MapColorMatrix(ColorMatrix.grayscale, sA);
 */
function MapColorMatrix(cm,skiparray) {
	if(!IsMapEngineRunning())
		return;
	if (skiparray == undefined)
		skiparray = new Array();
	var tile;
	var i=GetNumTiles()-1; //Same as for(var i=0; i<GetNumTiles(); ++i)
	do {
		if (skiparray[i]) continue;
		tile = GetTileImage(i).createSurface();
		tile.applyColorFX(0, 0, tile.width, tile.height,  cm);
		SetTileImage(i, tile.createImage() );
	}while(i--);
}

/* ---------------------------------------------------------------------- */

/**
 * Declare a ColorMatrix Object with some predefined color matrices.
 * You can add your own, like this:
 * 	//Grayscale with a reddish tint, like old photos
 * 	ColorMatrix["old_photo"]= CreateColorMatrix(0, 100,100,100,  0, 80,80,80,  0, 80,80,80);
 */
var ColorMatrix = { 
	"Swap_red_and_blue" : CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0), 
	"Swap_blue_and_green" : CreateColorMatrix(0, 255,0,0,  0, 0,0,255,  0, 0,255,0), 
	"Swap_green_and_red" : CreateColorMatrix(0, 0,255,0,  0, 255,0,0,  0, 0,0,255),
	"Rotate_forth" : CreateColorMatrix(0, 0,255,0,  0, 0,0,255,  0, 255,0,0),
	"Rotate_back" :  CreateColorMatrix(0, 0,0,255,  0, 255,0,0,  0, 0,255,0),
	"Reverse" : CreateColorMatrix(0, 0,255,255,  0, 255,0,255,  0, 255,255,0),
	"grayscale" : CreateColorMatrix(0, 85,85,85,  0, 85,85,85,  0, 85,85,85),
	"lighten20":  CreateColorMatrix(20, 255,0,0,  20, 0,255,0,  20, 0,0,255),
	"darken20": CreateColorMatrix(-20, 255,0,0,  -20, 0,255,0,  -20, 0,0,255),
	"hue_red":  CreateColorMatrix(20, 255,0,0,  0, 0,255,0,  0, 0,0,255),
	"hue_green":  CreateColorMatrix(0, 255,0,0,  20, 0,255,0,  0, 0,0,255),
	"hue_blue": CreateColorMatrix(0, 255,0,0,  0, 0,255,0,  20, 0,0,255),
	"hue_red55": CreateColorMatrix(55, 200,0,0,  0, 0,200,0,  0, 0,0,200),
	"hue_green55": CreateColorMatrix(0, 200,0,0,  55, 0,200,0,  0, 0,0,200),
	"hue_blue55": CreateColorMatrix(0, 200,0,0,  0, 0,200,0,  55, 0,0,200),
};


/* ---------------------------------------------------------------------- */

/**
 * Checks if a person with that name exists. This function is very RAM demanding, use scarcely.
 * @param {string} person Name of the person
 * @returns True if we found a person with that name, false if not
 * @type Boolean
 */
function DoesPersonExist(person) {
	var p = GetPersonList();
	var i=p.length-1;
	do {if(p[i] == person) return true;}while(i--);
	return false;
}

///////////////////////////////////////////////////////////

/**
 * Debugging function, will draw the Obstruction base of all sprites.
 * @param {Boolean} check Checks if the person exists (careful: function will kill Sphere if the person doesnt exist)
 */
function DrawPersonBases(check) { //See also DrawSpriteBases(), which edits the images and is not realtime.
	var p = GetPersonList();
	var i = p.length-1;
	do {DrawPersonBase(p[i], check);}while(i--);
}

/**
 * Debugging function, will draw the Obstruction base of one person
 * @param {string} person Name of the person
 * @param {Boolean} check Checks if the person exists (careful: function will kill Sphere if the person doesnt exist)
 */
function DrawPersonBase(person, check) {
	if(check && !DoesPersonExist(person))
		return false;

	var layer = GetPersonLayer(person);
	var base = GetPersonBase(person);
	var dx = (base.x2-base.x1+1)
	var dy = (base.y2-base.y1+1)
	var a1 = MapToScreenX(layer,GetPersonX(person)-(dx>>1)+1)
	var b1 = MapToScreenY(layer,GetPersonY(person)-(dy>>1))
	var a2 = MapToScreenX(layer,GetPersonX(person)+(dx>>1))
	var b2 = MapToScreenY(layer,GetPersonY(person)+(dy>>1))
    
	var lcol = CreateColor(255, 0, 255);

	//Outlined rectangle
	Line(a1,b1, a2, b1, lcol);
	Line(a1,b1, a1, b2, lcol);
	Line(a1,b2, a2, b2, lcol);
	Line(a2,b1, a2, b2, lcol);
}	

//--------------------------------------------------------------------------------

/**
 * First modify the default variables (optional), like, for example:
 *	Spotlight.colormatrix=CreateColorMatrix(0,255,0,0, 0,0,0,0, 0,0,0,0);
 *      Spotlight.offset=-4; //vertical offset from center of sprite's base.
 * Then call Init:
 *	Spotlight.init();
 * Then:
 *	Esthetica.darkroom(); //Enable Spotlight. If no parameter is given GetInputPerson() is used.
 *	Spotlight.Around("lamp"); //Additional spotlights (has displaybug when spots mix together)
 *
 *	Esthetica.done(); //Disable spotlight. Dont forget to run this in the MapChange.preWarp() if
 *	you are using it to set spotlights on Persons that will be destroyed with the map.
 * Add this to a renderscript:
 *	Esthetica.UpdateAndDraw(); //call always in a renderscript.
 *	
 */
var Spotlight = {
	a:32, b:32, c:32, offset:-4, step:0.05, r:28,
	bcol: CreateColor(0, 0, 0, 255), //Background surface color
	ccol: CreateColor(0, 0, 0, 0), //Spotlight color
	bimg: undefined, //Will contain a clean surface in the bcol color.
	spot: undefined,
	I: undefined,
	load: true,
	save: false,
	colormatrix: CreateColorMatrix(0,  0, 0, 0,    0,  0, 0, 0,    0,  0, 0, 0),
	Persons: [],
	active: false,

	/**
	 * You need to initialize the spotlight before using it.
	 * 	Spotlight.init();
	 */
	init: function(){
		this.bimg = CreateSurface(GetScreenWidth(), GetScreenHeight(), this.bcol);
		this.I = this.bimg;
		if(this.load)this.spot = LoadSurface('sfx/spotball.png');
		else this.spot = this.DarkCircle(this.a,this.b,this.c); //manually Blur the PNG for best fx
		if(this.save)
			this.spot.save('spotball.png');
		this.spot.applyColorFX(0, 0, this.spot.width, this.spot.height,  this.colormatrix);
		this.spotW = this.spot.width;
		this.spotH = this.spot.height;
		this.Persons = [];
		this.active = false;
	},
 
 	/**
	 * Activate a spotlight around this person
	 * @param {string} sprite Name of the person
	 */
	Around:function(sprite){this.Persons.push(sprite);this.active=true;},

	draw: function(sprite) {
		this.R = Math.floor(Math.sin(GetTime()*0.0025)*2);
		this.GPX = MapToScreenX(0,GetPersonX(sprite))-this.spotW*0.5;
		this.GPY = MapToScreenY(0,GetPersonY(sprite))-this.spotH*0.5;
		this.I.setBlendMode(REPLACE); //TODO: setBlendMode(ALPHA) modify script.cpp 
		// object->surface->SetBlendMode(mode == CImage32::REPLACE ? CImage32::REPLACE : CImage32::BLEND);
		//Add to script.cpp: { "ALPHA_ONLY",   CImage32::ALPHA_ONLY}, next to { "RGB_ONLY",   CImage32::RGB_ONLY},
		//this.I.setBlendMode(RGB_ONLY); 
  
		var s = this.spot.clone(); 
		s.rescale(this.spotW+this.R*2, this.spotH+this.R*2);
		this.I.blitSurface(s,this.GPX-this.R,this.GPY-this.R+this.offset);
	},

	UpdateAndDraw: function(){
		this.I = this.bimg.clone(); //TODO:clone() is not faster than CreateSurface;
		for(var i=0;i<this.Persons.length;i++)this.draw(this.Persons[i]);
		this.I.blit(0,0);
	},

	DarkCircle: function(a,b,c) {
		var max = Math.max(Math.max(a,b),c)<<1; //center pixel on square
		var cen = max>>1; //maximum dimensions for black square
		var Img = CreateSurface(max, max, this.bcol);
		Img.setBlendMode(REPLACE);
		var DSA=0;var color;var x;
		for(var i=1;i<1.4;i+=this.step){
			x=Math.floor((i*i-1)*100)+1;
			color = BlendColorsWeighted(this.ccol, this.bcol, x, 94-x);
			a=a/i; b=b/i; c=c/i;
			var DA=Math.floor(a);
			do{
				DSA=Math.sin(Math.acos(DA/a));
				Img.line(cen+DA,cen-c*DSA, cen+DA,cen+b*DSA,color);
				Img.line(cen-DA,cen-c*DSA, cen-DA,cen+b*DSA,color);
			}while(DA--);
		}
		Img.rotate(0.1, false);
		Img.replaceColor(Img.getPixel(0,0), this.bcol);
		return Img;//.createImage();
	}
}

//=============================================================

/**
 * Fasing out this code. Torch fx and Spotlight fx Object
 */
var DarkRoom = {
	radius: 16,
	r: 5,
	g: 5,
	b: 5,
	alpha: 32
}

/**
 * Fasing out this code. For one frame, sets a dark room around a person, now integrated into Spotlight
 */
function DarkRoomAround(sprite,radius,r,g,b,alpha) {
	if (radius!= undefined) DarkRoom.radius=radius;
	if (r != undefined) DarkRoom.r=r;
	if (g != undefined) DarkRoom.g=g;
	if (b != undefined) DarkRoom.b=b;
	if (alpha != undefined) DarkRoom.alpha=alpha;

	var rnd = Math.floor(Math.sin(GetTime()/100)*1);
	var DI = 8;
	do{
		DarkRoomAt(
			MapToScreenX(0,GetPersonX(sprite)),
			MapToScreenY(0,GetPersonY(sprite)) -8,
			CreateColor(DarkRoom.r+rnd*4, DarkRoom.g, DarkRoom.b-rnd*4, DarkRoom.alpha),
			DI*DI/2+DarkRoom.radius-3+rnd,
			DI*DI/2+DarkRoom.radius+rnd,
			DI*DI/2+DarkRoom.radius+rnd
		);
	}while(DI-=4)
}

/**
 * Fasing out this code. For one frame, sets a dark room at (X,Y), now being integrated into Spotlight
 */
function DarkRoomAt(x_c,y_c,color,a,b,c) {
	mov_ScreenImage = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(0, 0, 0, 142+100));
	mov_ScreenImage.setBlendMode(REPLACE);
	DA=Math.floor(a);
	do{
		DSA = Math.sin(Math.acos(DA/a)); //Have to put this in a lookuptable, but a changes to give pulsing fx, so I'd have to make a few tables... dunno if its worth the speed?
		mov_ScreenImage.line(x_c+DA,y_c-c*DSA, x_c+DA,y_c+b*DSA,color);
		mov_ScreenImage.line(x_c-DA,y_c-c*DSA, x_c-DA,y_c+b*DSA,color);
	}while(DA--);
	mov_ScreenImage.blit(0,0);
}

